//
//  table_V_O_R_G_.h
//  GSFontTools
//
//  Created by Georg Seifert on 22.01.26.
//  Copyright © 2026 schriftgestaltung.de. All rights reserved.
//

#import <GSFontTools/TTable.h>
#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/***
Vertical Origin table

The ``VORG`` table contains the vertical origin of each glyph
in a `CFF` or `CFF2` font.

This table is structured so that you can treat it like a dictionary keyed by glyph name.

``ttFont['VORG'][<glyphName>]`` will return the vertical origin for any glyph.

``ttFont['VORG'][<glyphName>] = <value>`` will set the vertical origin for any glyph.

See also https://learn.microsoft.com/en-us/typography/opentype/spec/vorg
*/

@interface table_V_O_R_G_ : TTable

@property (assign) int majorVersion;
@property (assign) int minorVersion;
@property (assign) int defaultVertOriginY;
@property (assign) int numVertOriginYMetrics;
@property (strong) NSDictionary *vOriginRecords;

@end

NS_ASSUME_NONNULL_END
